/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.util;

import de.willuhn.logging.Logger;
import java.util.ArrayList;
import java.util.Properties;

public class TypedProperties
extends Properties {
    public boolean getBoolean(String name, boolean defaultValue) {
        String s = this.getInternal(name, defaultValue ? "true" : "false");
        return "true".equalsIgnoreCase(s);
    }

    public int getInt(String name, int defaultValue) {
        String s = this.getInternal(name, Integer.toString(defaultValue));
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            Logger.error("unable to parse " + name + "=" + s + " as integer", e);
            return defaultValue;
        }
    }

    public long getLong(String name, long defaultValue) {
        String s = this.getInternal(name, Long.toString(defaultValue));
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            Logger.error("unable to parse " + name + "=" + s + " as long", e);
            return defaultValue;
        }
    }

    public double getDouble(String name, double defaultValue) {
        String s = this.getInternal(name, Double.toString(defaultValue));
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            Logger.error("unable to parse " + name + "=" + s + " as double", e);
            return defaultValue;
        }
    }

    public String getString(String name, String defaultValue) {
        return this.getInternal(name, defaultValue);
    }

    public String[] getList(String name, String[] defaultValues) {
        ArrayList<String> l = new ArrayList<String>();
        String s = null;
        for (int i = 0; i < 255; ++i) {
            s = this.getInternal(name + "." + i, null);
            if (s == null) continue;
            l.add(s);
        }
        return l.size() > 0 ? l.toArray(new String[l.size()]) : defaultValues;
    }

    public void setBoolean(String name, boolean value) {
        this.setInternal(name, value ? "true" : "false");
    }

    public void setInt(String name, int value) {
        this.setInternal(name, Integer.toString(value));
    }

    public void setDouble(String name, double value) {
        this.setInternal(name, Double.toString(value));
    }

    public void setLong(String name, long value) {
        this.setInternal(name, Long.toString(value));
    }

    public void setList(String name, String[] values) {
        int i;
        for (i = 0; i < 255; ++i) {
            super.remove(name + "." + i);
        }
        if (values == null || values.length == 0) {
            return;
        }
        for (i = 0; i < values.length && i < 255; ++i) {
            if (values[i] == null) continue;
            super.setProperty(name + "." + i, values[i]);
        }
    }

    private String getInternal(String name, String defaultValue) {
        String s = super.getProperty(name, defaultValue);
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private void setInternal(String name, String value) {
        if (value == null) {
            super.remove(name);
        } else {
            super.setProperty(name, value);
        }
    }
}

